#include <iostream>
#include <vector>
#include <queue>
#include <algorithm>
using namespace std;

const int MAXN = 100000;

vector<vector<int>> graf;
vector<int> vrednost_cvora;

vector<int> pronadji_put(int pocetak, int kraj, int n) {
    vector<int> glavni(n + 1, -1);
    vector<bool> pronadjen(n + 1, false);
    queue<int> q;

    q.push(pocetak);
    pronadjen[pocetak] = true;

    while (!q.empty()) {
        int tekuci = q.front();
        q.pop();

        if (tekuci == kraj){
          break;
        }

        for (int susedni : graf[tekuci]) {
            if (!pronadjen[susedni]) {
                pronadjen[susedni] = true;
                glavni[susedni] = tekuci;
                q.push(susedni);
            }
        }
    }

    vector<int> put;
    for (int v = kraj; v != -1; v = glavni[v]) {
        put.push_back(v);
    }

    reverse(put.begin(), put.end());
    return put;
}

int pronadji_medijanu(vector<int>& upiti) {

    sort(upiti.begin(), upiti.end());
    return upiti[(upiti.size() - 1) / 2];
}

int main() {
    int N, M, Q, P;
    cin >> N >> M >> Q >> P;

    graf.resize(N + 1);
    vrednost_cvora.resize(N + 1);

    for (int i = 1; i <= N; ++i) {
        cin >> vrednost_cvora[i];
    }

    for (int i = 0; i < M; ++i) {
        int u, v;
        cin >> u >> v;

        graf[u].push_back(v);
        graf[v].push_back(u);
    }

    cerr << "Lista susedstva:" << endl;
    for (int i = 1; i <= N; ++i) {
        cerr << i << ": ";
        for (int susedni : graf[i]) {
            cerr << susedni << " ";
        }
        cerr << endl;
    }

    int a1, b1;
    vector<int> rezultati;

    int proslo_resenje = 0;

    for (int i = 1; i <= Q; ++i) {
        cin >> a1 >> b1;

        int a = (a1 + proslo_resenje * P - 1) % N + 1;
        int b = (b1 + proslo_resenje * P - 1) % N + 1;

        cerr << "Upit " << i << ": (" << a << ", " << b << ")" << endl;

        vector<int> put_cvora = pronadji_put(a, b, N);

        vector<int> vrednost_puta;
        for (int cvor : put_cvora) {
            vrednost_puta.push_back(vrednost_cvora[cvor]);
        }

        int medijana = pronadji_medijanu(vrednost_puta);

        rezultati.push_back(medijana);

        proslo_resenje = medijana;
    }

    for (int medijana : rezultati) {
        cout << medijana << endl;
    }

    return 0;
}